package com.ruoyi.algorithm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmScenePiece;
import com.ruoyi.algorithm.service.IAlgorithmScenePieceService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 场景算法块Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/scene/piece")
public class AlgorithmScenePieceController extends BaseController
{
    @Autowired
    private IAlgorithmScenePieceService algorithmScenePieceService;

    /**
     * 查询场景算法块列表
     */
    @PreAuthorize("@ss.hasPermi('system:piece:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmScenePiece algorithmScenePiece)
    {
        startPage();
        List<AlgorithmScenePiece> list = algorithmScenePieceService.selectAlgorithmScenePieceList(algorithmScenePiece);
        return getDataTable(list);
    }

    /**
     * 导出场景算法块列表
     */
    @PreAuthorize("@ss.hasPermi('system:piece:export')")
    @Log(title = "场景算法块", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, AlgorithmScenePiece algorithmScenePiece)
    {
        List<AlgorithmScenePiece> list = algorithmScenePieceService.selectAlgorithmScenePieceList(algorithmScenePiece);
        ExcelUtil<AlgorithmScenePiece> util = new ExcelUtil<AlgorithmScenePiece>(AlgorithmScenePiece.class);
        util.exportExcel(response, list, "场景算法块数据");
    }

    /**
     * 获取场景算法块详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:piece:query')")
    @GetMapping(value = "/{sceneId}")
    public AjaxResult getInfo(@PathVariable("sceneId") Long sceneId)
    {
        return success(algorithmScenePieceService.selectAlgorithmScenePieceBySceneId(sceneId));
    }

    /**
     * 新增场景算法块
     */
    @PreAuthorize("@ss.hasPermi('system:piece:add')")
    @Log(title = "场景算法块", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmScenePiece algorithmScenePiece)
    {
        return toAjax(algorithmScenePieceService.insertAlgorithmScenePiece(algorithmScenePiece));
    }

    /**
     * 修改场景算法块
     */
    @PreAuthorize("@ss.hasPermi('system:piece:edit')")
    @Log(title = "场景算法块", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmScenePiece algorithmScenePiece)
    {
        return toAjax(algorithmScenePieceService.updateAlgorithmScenePiece(algorithmScenePiece));
    }

    /**
     * 删除场景算法块
     */
    @PreAuthorize("@ss.hasPermi('system:piece:remove')")
    @Log(title = "场景算法块", businessType = BusinessType.DELETE)
	@DeleteMapping("/{sceneIds}")
    public AjaxResult remove(@PathVariable Long[] sceneIds)
    {
        return toAjax(algorithmScenePieceService.deleteAlgorithmScenePieceBySceneIds(sceneIds));
    }
}
