package com.ruoyi.algorithm.controller;

import com.ruoyi.algorithm.domain.AlgorithmBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmBaseListDto;
import com.ruoyi.algorithm.service.IAlgorithmBaseService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 算法Controller
 *
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/base")
public class AlgorithmBaseController extends BaseController {
    @Autowired
    private IAlgorithmBaseService algorithmBaseService;

    /**
     * 查询算法列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmBase algorithmBase) {
        startPage();
        List<AlgorithmBaseListDto> list = algorithmBaseService.selectAlgorithmBaseListDto(algorithmBase);
        return getDataTable(list);
    }

    /**
     * 查询算法列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:list')")
    @GetMapping("/list/all")
    public AjaxResult listAll(AlgorithmBase algorithmBase) {
        return success(algorithmBaseService.selectAlgorithmBaseList(algorithmBase));
    }

    /**
     * 获取算法详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return success(algorithmBaseService.selectAlgorithmBaseById(id));
    }

    /**
     * 新增算法
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:add')")
    @Log(title = "算法", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmBase algorithmBase) {
        algorithmBase.setCreateBy(getUsername());
        return toAjax(algorithmBaseService.insertAlgorithmBase(algorithmBase));
    }

    /**
     * 修改算法
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:edit')")
    @Log(title = "算法", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmBase algorithmBase) {
        algorithmBase.setUpdateBy(getUsername());
        return toAjax(algorithmBaseService.updateAlgorithmBase(algorithmBase));
    }

    /**
     * 删除算法
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmBase:remove')")
    @Log(title = "算法", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(algorithmBaseService.deleteAlgorithmBaseByIds(ids));
    }
}
