package com.ruoyi.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * flink相关配置
 * 
 * @author ruoyi
 */
@Component
@ConfigurationProperties(prefix = "flink")
public class FlinkConfig
{
    /** 地址 */
    private static String host;

    /** 端口 */
    private static String port;

    /** jarId */
    private static String jarId;

    /** flink启动类 */
    private static String entryClass;

    /** 启动参数 */
    private static String programArgs;

    public static String getHost() {
        return host;
    }

    public void setHost(String host) {
        FlinkConfig.host = host;
    }

    public static String getPort() {
        return port;
    }

    public void setPort(String port) {
        FlinkConfig.port = port;
    }

    public static String getJarId() {
        return jarId;
    }

    public void setJarId(String jarId) {
        FlinkConfig.jarId = jarId;
    }

    public static String getEntryClass() {
        return entryClass;
    }

    public void setEntryClass(String entryClass) {
        FlinkConfig.entryClass = entryClass;
    }

    public static String getProgramArgs() {
        return programArgs;
    }

    public void setProgramArgs(String programArgs) {
        FlinkConfig.programArgs = programArgs;
    }
}
