package com.ruoyi.icc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.DefaultClient;
import com.dahuatech.icc.oauth.http.IClient;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.model.v202010.GeneralRequest;
import com.dahuatech.icc.oauth.model.v202010.GeneralResponse;
import com.dahuatech.icc.oauth.model.v202010.OauthPublicKeyResponse;
import com.dahuatech.icc.util.SignUtil;
import com.ruoyi.icc.domain.IccConfigDomain;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 周昊
 * @desc ...
 * @date 2023-05-18 15:40:57
 */
public class IccUtil {

    private static final String HOST = "https://124.160.33.135:4077";

    private static final String PUBLIC_KEY_URL = HOST + "/evo-apigw/evo-oauth/1.0.0/oauth/public-key";

    private static final String TOKEN_URL = HOST + "/evo-apigw/evo-oauth/1.0.0/oauth/extend/token";

    private static final String START_VIDEO_URL = "/evo-apigw/admin/API/MTS/Video/StartVideo";

    private static final String START_Playback_URL = "/evo-apigw/admin/API/SS/Playback/StartPlaybackByTime";

    public static String publicKey() throws ClientException {
        IccHttpHttpRequest pubRequest = new IccHttpHttpRequest(PUBLIC_KEY_URL, Method.GET);
        String pubBody = pubRequest.execute();
        OauthPublicKeyResponse keyResp = (OauthPublicKeyResponse) BeanUtil.toBean(pubBody, OauthPublicKeyResponse.class);
        JSONObject entries = JSONUtil.parseObj(pubBody);
        JSONObject data = entries.get("data", JSONObject.class);
        String publicKey = data.get("publicKey", String.class);
        return publicKey;
    }

    public static String userPasswordAuth() throws ClientException {
        String publicKey = publicKey();
        Map<String, Object> map = new HashMap();
        map.put("grant_type", "password");
        map.put("username", IccConfigDomain.getUsername());
        map.put("password", SignUtil.encryptRSA(IccConfigDomain.getPassword(), publicKey));
        map.put("client_id", IccConfigDomain.getClientId());
        map.put("client_secret", IccConfigDomain.getClientSecret());
        map.put("public_key", publicKey);
        IccHttpHttpRequest pr = new IccHttpHttpRequest(TOKEN_URL, Method.POST, JSONUtil.toJsonStr(map));
        String prBody = pr.execute();
        IccTokenResponse keyResp = (IccTokenResponse) BeanUtil.toBean(prBody, IccTokenResponse.class);
        JSONObject entries = JSONUtil.parseObj(prBody);
        JSONObject data = entries.get("data", JSONObject.class);
        return "bearer " + data.get("access_token", String.class);
    }

    public static String startVideo(String channelId) throws ClientException {
        IClient iClient = new DefaultClient();
        /**
         * 1、请求地址是统一网关入口，以 /evo-apigw 开头
         * 2、方法参见 @see com.dahuatech.hutool.http.Method
         */
        GeneralRequest generalRequest = new GeneralRequest(START_VIDEO_URL, Method.POST);
        // set http post body
        generalRequest.body("{\n" +
                "  \"data\": {\n" +
                "    \"channelId\": \"" + channelId + "\",\n" +
                "    \"dataType\": \"1\",\n" +
                "    \"streamType\": \"1\"\n" +
                "  }\n" +
                "}");
        // set header
        generalRequest.header("Authorization", userPasswordAuth());
        // 发起请求处理应答
        GeneralResponse generalResponse = iClient.doAction(generalRequest, generalRequest.getResponseClass());

        JSONObject entries = JSONUtil.parseObj(generalResponse);
        JSONObject result = entries.get("result", JSONObject.class);
        JSONObject data = result.get("data", JSONObject.class);
        String url = data.get("url", String.class);
        String token = data.get("token", String.class);
        url = url.substring(0, url.indexOf("|"));
        return url + "?token=" + token;
    }

    public static String StartPlaybackByTime(String channelId, Long startTime, Long endTime) throws ClientException {
        IClient iClient = new DefaultClient();
        /**
         * 1、请求地址是统一网关入口，以 /evo-apigw 开头
         * 2、方法参见 @see com.dahuatech.hutool.http.Method
         */
        GeneralRequest generalRequest = new GeneralRequest(START_Playback_URL, Method.POST);
        // set http post body
        generalRequest.body("{\n" +
                "  \"data\": {\n" +
                "    \"channelId\": \"" + channelId + "\",\n" +
                "    \"recordSource\": \"2\",\n" +
                "    \"startTime\": \"" + startTime + "\",\n" +
                "    \"endTime\": \"" + endTime + "\",\n" +
                "    \"streamType\": \"1\",\n" +
                "    \"recordType\": \"1\"\n" +
                "  }\n" +
                "}");
        // set header
        generalRequest.header("Authorization", userPasswordAuth());
        // 发起请求处理应答
        GeneralResponse generalResponse = iClient.doAction(generalRequest, generalRequest.getResponseClass());

        JSONObject entries = JSONUtil.parseObj(generalResponse);
        JSONObject result = entries.get("result", JSONObject.class);
        JSONObject data = result.get("data", JSONObject.class);
        String url = data.get("url", String.class);
        String token = data.get("token", String.class);
        url = url.substring(url.indexOf("|") + 1);
        return url + "?token=" + token;
    }

}
