package com.ruoyi.algorithm.service.impl;

import cn.hutool.json.JSONUtil;
import com.ruoyi.algorithm.domain.AlgorithmSceneStatus;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneStatusCameraListDto;
import com.ruoyi.algorithm.mapper.AlgorithmSceneStatusMapper;
import com.ruoyi.algorithm.service.IAlgorithmSceneStatusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 算法启动摄像头配置Service业务层处理
 *
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmSceneStatusServiceImpl implements IAlgorithmSceneStatusService {
    @Autowired
    private AlgorithmSceneStatusMapper algorithmSceneStatusMapper;


    @Override
    public AlgorithmSceneStatus createBySceneId(Long sceneId) {
        //清空当前sceneId数据
        algorithmSceneStatusMapper.deleteAlgorithmSceneStatusBySceneId(sceneId);

        //生成全新的数据并插入
        AlgorithmSceneStatus algorithmSceneStatus = algorithmSceneStatusMapper.selectAlgorithmSceneBase(sceneId);
        List<AlgorithmSceneStatusCameraListDto> cameraList = algorithmSceneStatusMapper.selectCameraList(sceneId);
        for (int i = 0; i < cameraList.size(); i++) {
            cameraList.get(i).setSort(i);
        }
        algorithmSceneStatus.setCameraList(JSONUtil.toJsonStr(cameraList));
        algorithmSceneStatusMapper.insertAlgorithmSceneStatus(algorithmSceneStatus);
        return algorithmSceneStatus;
    }

    @Override
    public int deleteBySceneId(Long sceneId) {
        return algorithmSceneStatusMapper.deleteAlgorithmSceneStatusBySceneId(sceneId);
    }
}
