package com.ruoyi.algorithm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmBaseTypeMapper;
import com.ruoyi.algorithm.domain.AlgorithmBaseType;
import com.ruoyi.algorithm.service.IAlgorithmBaseTypeService;

/**
 * 算法预警类型Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmBaseTypeServiceImpl implements IAlgorithmBaseTypeService 
{
    @Autowired
    private AlgorithmBaseTypeMapper algorithmBaseTypeMapper;

    /**
     * 查询算法预警类型
     * 
     * @param algorithmId 算法预警类型主键
     * @return 算法预警类型
     */
    @Override
    public AlgorithmBaseType selectAlgorithmBaseTypeByAlgorithmId(Long algorithmId)
    {
        return algorithmBaseTypeMapper.selectAlgorithmBaseTypeByAlgorithmId(algorithmId);
    }

    /**
     * 查询算法预警类型列表
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 算法预警类型
     */
    @Override
    public List<AlgorithmBaseType> selectAlgorithmBaseTypeList(AlgorithmBaseType algorithmBaseType)
    {
        return algorithmBaseTypeMapper.selectAlgorithmBaseTypeList(algorithmBaseType);
    }

    /**
     * 新增算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    @Override
    public int insertAlgorithmBaseType(AlgorithmBaseType algorithmBaseType)
    {
        return algorithmBaseTypeMapper.insertAlgorithmBaseType(algorithmBaseType);
    }

    /**
     * 修改算法预警类型
     * 
     * @param algorithmBaseType 算法预警类型
     * @return 结果
     */
    @Override
    public int updateAlgorithmBaseType(AlgorithmBaseType algorithmBaseType)
    {
        return algorithmBaseTypeMapper.updateAlgorithmBaseType(algorithmBaseType);
    }

    /**
     * 批量删除算法预警类型
     * 
     * @param algorithmIds 需要删除的算法预警类型主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmBaseTypeByAlgorithmIds(Long[] algorithmIds)
    {
        return algorithmBaseTypeMapper.deleteAlgorithmBaseTypeByAlgorithmIds(algorithmIds);
    }

    /**
     * 删除算法预警类型信息
     * 
     * @param algorithmId 算法预警类型主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmBaseTypeByAlgorithmId(Long algorithmId)
    {
        return algorithmBaseTypeMapper.deleteAlgorithmBaseTypeByAlgorithmId(algorithmId);
    }
}
