package com.ruoyi.algorithm.service;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmSceneBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneDetailsDto;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneListDto;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneSaveDto;

/**
 * 算法场景Service接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface IAlgorithmSceneBaseService 
{
    /**
     * 查询算法场景
     * 
     * @param id 算法场景主键
     * @return 算法场景
     */
    public AlgorithmSceneBase selectAlgorithmSceneBaseById(Long id);

    /**
     * 查询算法场景列表
     * 
     * @param algorithmSceneBase 算法场景
     * @return 算法场景集合
     */
    public List<AlgorithmSceneBase> selectAlgorithmSceneBaseList(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 新增算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    public int insertAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 修改算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    public int updateAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase);

    /**
     * 批量删除算法场景
     * 
     * @param ids 需要删除的算法场景主键集合
     * @return 结果
     */
    public int deleteAlgorithmSceneBaseByIds(Long[] ids);

    /**
     * 删除算法场景信息
     * 
     * @param id 算法场景主键
     * @return 结果
     */
    public int deleteAlgorithmSceneBaseById(Long id);

    List<AlgorithmSceneListDto> selectAlgorithmSceneListDto(AlgorithmSceneBase algorithmSceneBase);

    int editStatus(AlgorithmSceneBase algorithmSceneBase);

    AlgorithmSceneDetailsDto selectAlgorithmSceneDetailsDtoById(Long id);

    int insertAlgorithmSceneSaveDto(AlgorithmSceneSaveDto algorithmSceneSaveDto);

    int updateAlgorithmSceneSaveDto(AlgorithmSceneSaveDto algorithmSceneSaveDto);

    int copyById(Long id, String username);
}
