package com.ruoyi.algorithm.service;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmBaseListDto;

/**
 * 算法Service接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface IAlgorithmBaseService 
{
    /**
     * 查询算法
     * 
     * @param id 算法主键
     * @return 算法
     */
    public AlgorithmBase selectAlgorithmBaseById(Long id);

    /**
     * 查询算法列表
     * 
     * @param algorithmBase 算法
     * @return 算法集合
     */
    public List<AlgorithmBase> selectAlgorithmBaseList(AlgorithmBase algorithmBase);

    /**
     * 新增算法
     * 
     * @param algorithmBase 算法
     * @return 结果
     */
    public int insertAlgorithmBase(AlgorithmBase algorithmBase);

    /**
     * 修改算法
     * 
     * @param algorithmBase 算法
     * @return 结果
     */
    public int updateAlgorithmBase(AlgorithmBase algorithmBase);

    /**
     * 批量删除算法
     * 
     * @param ids 需要删除的算法主键集合
     * @return 结果
     */
    public int deleteAlgorithmBaseByIds(Long[] ids);

    /**
     * 删除算法信息
     * 
     * @param id 算法主键
     * @return 结果
     */
    public int deleteAlgorithmBaseById(Long id);

    /**
     * PC端查询算法列表
     *
     * @param algorithmBase 算法
     * @return 算法集合
     */
    public List<AlgorithmBaseListDto> selectAlgorithmBaseListDto(AlgorithmBase algorithmBase);

    public AlgorithmBaseListDto selectAlgorithmBaseListDtoById(Long id);

    public int insertAlgorithmBaseListDto(AlgorithmBaseListDto algorithmBaseListDto);

    public int updateAlgorithmBaseListDto(AlgorithmBaseListDto algorithmBaseListDto);
}
