package com.ruoyi.algorithm.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 算法摄像头对象 algorithm_camera_base
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Data
public class AlgorithmCameraBase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 摄像头名 */
    @Excel(name = "摄像头名")
    private String cameraName;

    @Excel(name = "摄像头编号")
    private String cameraNo;

    /** 摄像头视频流地址 */
    @Excel(name = "摄像头视频流地址")
    private String rtsp;

    /** 排序 */
    @Excel(name = "排序")
    private Long sort;

    /** 归属矿场 */
    @Excel(name = "归属矿场")
    private String belong;

    /** 帐号状态（0正常 */
    @Excel(name = "帐号状态", readConverterExp = "帐号状态（0正常")
    private String status;

    /** 删除标志（0代表存在 */
    private String delFlag;

    @Excel(name = "摄像头支持的算法类型")
    private String algorithmType;
}
