package com.ruoyi.algorithm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmPieceVariable;
import com.ruoyi.algorithm.service.IAlgorithmPieceVariableService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 策略算法块所需参数Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/piece/variable")
public class AlgorithmPieceVariableController extends BaseController
{
    @Autowired
    private IAlgorithmPieceVariableService algorithmPieceVariableService;

    /**
     * 查询策略算法块所需参数列表
     */
    @PreAuthorize("@ss.hasPermi('system:variable:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmPieceVariable algorithmPieceVariable)
    {
        startPage();
        List<AlgorithmPieceVariable> list = algorithmPieceVariableService.selectAlgorithmPieceVariableList(algorithmPieceVariable);
        return getDataTable(list);
    }

    /**
     * 查询策略算法块所需参数列表
     */
    @PreAuthorize("@ss.hasPermi('system:variable:list')")
    @GetMapping("/list/{pieceId}")
    public AjaxResult listByPieceId(@PathVariable("pieceId") Long pieceId)
    {
        AlgorithmPieceVariable algorithmPieceVariable = new AlgorithmPieceVariable();
        algorithmPieceVariable.setAlgorithmPieceBaseId(pieceId);
        return success(algorithmPieceVariableService.selectAlgorithmPieceVariableList(algorithmPieceVariable));
    }

    /**
     * 导出策略算法块所需参数列表
     */
    @PreAuthorize("@ss.hasPermi('system:variable:export')")
    @Log(title = "策略算法块所需参数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, AlgorithmPieceVariable algorithmPieceVariable)
    {
        List<AlgorithmPieceVariable> list = algorithmPieceVariableService.selectAlgorithmPieceVariableList(algorithmPieceVariable);
        ExcelUtil<AlgorithmPieceVariable> util = new ExcelUtil<AlgorithmPieceVariable>(AlgorithmPieceVariable.class);
        util.exportExcel(response, list, "策略算法块所需参数数据");
    }

    /**
     * 获取策略算法块所需参数详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:variable:query')")
    @GetMapping(value = "/{algorithmPieceBaseId}")
    public AjaxResult getInfo(@PathVariable("algorithmPieceBaseId") Long algorithmPieceBaseId)
    {
        return success(algorithmPieceVariableService.selectAlgorithmPieceVariableByAlgorithmPieceBaseId(algorithmPieceBaseId));
    }

    /**
     * 新增策略算法块所需参数
     */
    @PreAuthorize("@ss.hasPermi('system:variable:add')")
    @Log(title = "策略算法块所需参数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmPieceVariable algorithmPieceVariable)
    {
        return toAjax(algorithmPieceVariableService.insertAlgorithmPieceVariable(algorithmPieceVariable));
    }

    /**
     * 修改策略算法块所需参数
     */
    @PreAuthorize("@ss.hasPermi('system:variable:edit')")
    @Log(title = "策略算法块所需参数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmPieceVariable algorithmPieceVariable)
    {
        return toAjax(algorithmPieceVariableService.updateAlgorithmPieceVariable(algorithmPieceVariable));
    }

    /**
     * 删除策略算法块所需参数
     */
    @PreAuthorize("@ss.hasPermi('system:variable:remove')")
    @Log(title = "策略算法块所需参数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{algorithmPieceBaseIds}")
    public AjaxResult remove(@PathVariable Long[] algorithmPieceBaseIds)
    {
        return toAjax(algorithmPieceVariableService.deleteAlgorithmPieceVariableByAlgorithmPieceBaseIds(algorithmPieceBaseIds));
    }
}
