package com.ruoyi.algorithm.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.lang.hash.Hash;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.algorithm.domain.dto.AlgorithmCameraListDto;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.http.HttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmCameraBase;
import com.ruoyi.algorithm.service.IAlgorithmCameraBaseService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 算法摄像头Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Slf4j
@RestController
@RequestMapping("/system/algorithm/camera/base")
public class AlgorithmCameraBaseController extends BaseController
{

    @Value("${ai.camera.url}")
    private String aiCameraUrl;

    @Autowired
    private IAlgorithmCameraBaseService algorithmCameraBaseService;

    /**
     * 查询算法摄像头列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmCameraBase algorithmCameraBase)
    {
        startPage();
        List<AlgorithmCameraListDto> list = algorithmCameraBaseService.selectAlgorithmCameraListDto(algorithmCameraBase);
        return getDataTable(list);
    }

    /**
     * 查询算法摄像头列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:list')")
    @GetMapping("/list/all")
    public AjaxResult listAll(AlgorithmCameraBase algorithmCameraBase)
    {
        return success(algorithmCameraBaseService.selectAlgorithmCameraBaseList(algorithmCameraBase));
    }

    /**
     * 获取算法摄像头详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(algorithmCameraBaseService.selectAlgorithmCameraBaseById(id));
    }

    /**
     * 新增算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:add')")
    @Log(title = "算法摄像头", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setCreateBy(getUsername());
        algorithmCameraBaseService.insertAlgorithmCameraBase(algorithmCameraBase);
        String belong = algorithmCameraBase.getBelong();
        //查询该矿下所有信息
        AlgorithmCameraBase algorithmCameraBaseReq = new AlgorithmCameraBase();
        algorithmCameraBaseReq.setBelong(belong);
        List<AlgorithmCameraBase> list = algorithmCameraBaseService.selectAlgorithmCameraBaseList(algorithmCameraBaseReq);
        Executors.newFixedThreadPool(1).execute(() ->{
            //算法平台通知
            JSONObject param = new JSONObject();
            param.put("AllAlgorithmPtype","");
            JSONArray cameraList = new JSONArray();
            if(!CollectionUtils.isEmpty(list)){
                list.forEach(base ->{
                    if(!StringUtils.isEmpty(base.getRtsp())){
                        JSONObject camera = new JSONObject();
                        camera.put("inputDataPath",base.getRtsp());
                        camera.put("selectalgorithmPtype",base.getAlgorithmType());
                        camera.put("cameraName",base.getCameraNo());
                        cameraList.add(camera);
                    }
                });
            }
            JSONObject camera = new JSONObject();
            camera.put("inputDataPath",algorithmCameraBase.getRtsp());
            camera.put("selectalgorithmPtype",algorithmCameraBase.getAlgorithmType());
            camera.put("cameraName",algorithmCameraBase.getCameraNo());
            cameraList.add(camera);
            param.put("cameraList",cameraList);
            try{
                String apiUrl = "";
                if("乌海矿".equals(belong)){
                    apiUrl = aiCameraUrl.split(",")[1];
                }
                if("海南矿".equals(belong)){
                    apiUrl = aiCameraUrl.split(",")[0];
                }
                if(!StringUtils.isEmpty(apiUrl)){
                    log.info("发起通信");
                    String result = HttpUtil.post(apiUrl,param.toJSONString());
                    log.info("通信完成"+result);
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        });
        return AjaxResult.success();
    }

    /**
     * 修改算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:edit')")
    @Log(title = "算法摄像头", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setUpdateBy(getUsername());
        String belong = algorithmCameraBase.getBelong();
        //查询该矿下所有信息
        AlgorithmCameraBase algorithmCameraBaseReq = new AlgorithmCameraBase();
        algorithmCameraBaseReq.setBelong(belong);
        List<AlgorithmCameraBase> list = algorithmCameraBaseService.selectAlgorithmCameraBaseList(algorithmCameraBaseReq);
        Executors.newFixedThreadPool(1).execute(() ->{
            //算法平台通知
            JSONObject param = new JSONObject();
            param.put("AllAlgorithmPtype","");
            JSONArray cameraList = new JSONArray();
            if(!CollectionUtils.isEmpty(list)){
                list.forEach(base ->{
                    if(algorithmCameraBase.getId().equals(base.getId())){
                        return;
                    }
                    if(!StringUtils.isEmpty(base.getRtsp())){
                        JSONObject camera = new JSONObject();
                        camera.put("inputDataPath",base.getRtsp());
                        camera.put("selectalgorithmPtype",base.getAlgorithmType());
                        camera.put("cameraName",base.getCameraNo());
                        cameraList.add(camera);
                    }
                });
            }
            JSONObject camera = new JSONObject();
            camera.put("inputDataPath",algorithmCameraBase.getRtsp());
            camera.put("selectalgorithmPtype",algorithmCameraBase.getAlgorithmType());
            camera.put("cameraName",algorithmCameraBase.getCameraNo());
            cameraList.add(camera);
            param.put("cameraList",cameraList);
            try{
                String apiUrl = "";
                if("乌海矿".equals(belong)){
                    apiUrl = aiCameraUrl.split(",")[1];
                }
                if("海南矿".equals(belong)){
                    apiUrl = aiCameraUrl.split(",")[0];
                }
                if(!StringUtils.isEmpty(apiUrl)){
                    log.info("发起通信");
                    String result = HttpUtil.post(apiUrl,param.toJSONString());
                    log.info("通信完成"+result);
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        });
        return toAjax(algorithmCameraBaseService.updateAlgorithmCameraBase(algorithmCameraBase));
    }

    /**
     * 删除算法摄像头
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmCamera:remove')")
    @Log(title = "算法摄像头", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(algorithmCameraBaseService.deleteAlgorithmCameraBaseByIds(ids));
    }
}
