package com.ruoyi.algorithm.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.ruoyi.common.config.FlinkConfig;

import java.util.HashMap;

/**
 * @author 周昊
 * @desc ...
 * @date 2023-05-09 09:36:34
 */
public class FlinkRestApiUtil {

    public static String runJar(String jarId, String entryClass, String programArgs) {
        String url = "http://{}:{}/jars/{}/run?entry-class={}&program-args={}";
        url = StrUtil.format(url, FlinkConfig.getHost(), FlinkConfig.getPort(), jarId, entryClass, programArgs);

        return HttpUtil.post(url, new HashMap<>());
    }

    public static String cancelJob(String jobId) {
        String url = "http://{}:{}/jobs/{}/yarn-cancel";
        url = StrUtil.format(url, FlinkConfig.getHost(), FlinkConfig.getPort(), jobId);

        return HttpUtil.get(url);
    }
}
