package com.ruoyi.algorithm.mapper;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmCameraBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmCameraListDto;

/**
 * 算法摄像头Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmCameraBaseMapper 
{
    /**
     * 查询算法摄像头
     * 
     * @param id 算法摄像头主键
     * @return 算法摄像头
     */
    public AlgorithmCameraBase selectAlgorithmCameraBaseById(Long id);

    /**
     * 查询算法摄像头列表
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 算法摄像头集合
     */
    public List<AlgorithmCameraBase> selectAlgorithmCameraBaseList(AlgorithmCameraBase algorithmCameraBase);

    /**
     * 新增算法摄像头
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 结果
     */
    public int insertAlgorithmCameraBase(AlgorithmCameraBase algorithmCameraBase);

    /**
     * 修改算法摄像头
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 结果
     */
    public int updateAlgorithmCameraBase(AlgorithmCameraBase algorithmCameraBase);

    /**
     * 删除算法摄像头
     * 
     * @param id 算法摄像头主键
     * @return 结果
     */
    public int deleteAlgorithmCameraBaseById(Long id);

    /**
     * 批量删除算法摄像头
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteAlgorithmCameraBaseByIds(Long[] ids);

    List<AlgorithmCameraListDto> selectAlgorithmCameraListDto(AlgorithmCameraBase algorithmCameraBase);
}
