package com.ruoyi.algorithm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.algorithm.domain.dto.AlgorithmPieceListDto;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmPieceBase;
import com.ruoyi.algorithm.service.IAlgorithmPieceBaseService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 策略算法块Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/piece/base")
public class AlgorithmPieceBaseController extends BaseController
{
    @Autowired
    private IAlgorithmPieceBaseService algorithmPieceBaseService;

    /**
     * 查询策略算法块列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmPiece:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmPieceBase algorithmPieceBase)
    {
        startPage();
        List<AlgorithmPieceListDto> list = algorithmPieceBaseService.selectAlgorithmPieceListDto(algorithmPieceBase);
        return getDataTable(list);
    }

    /**
     * 获取策略算法块详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmPiece:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(algorithmPieceBaseService.selectAlgorithmPieceBaseById(id));
    }

    /**
     * 新增策略算法块
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmPiece:add')")
    @Log(title = "策略算法块", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmPieceBase algorithmPieceBase)
    {
        algorithmPieceBase.setCreateBy(getUsername());
        return toAjax(algorithmPieceBaseService.insertAlgorithmPieceBase(algorithmPieceBase));
    }

    /**
     * 修改策略算法块
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmPiece:edit')")
    @Log(title = "策略算法块", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmPieceBase algorithmPieceBase)
    {
        algorithmPieceBase.setUpdateBy(getUsername());
        return toAjax(algorithmPieceBaseService.updateAlgorithmPieceBase(algorithmPieceBase));
    }

    /**
     * 删除策略算法块
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmPiece:remove')")
    @Log(title = "策略算法块", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(algorithmPieceBaseService.deleteAlgorithmPieceBaseByIds(ids));
    }
}
