package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 策略算法块对象 algorithm_piece_base
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmPieceBase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 算法块名 */
    @Excel(name = "算法块名")
    private String pieceName;

    /** 排序 */
    @Excel(name = "排序")
    private Long sort;

    /** 算法块对应Class */
    @Excel(name = "算法块对应Class")
    private String clazz;

    /** 状态（0正常 */
    @Excel(name = "状态", readConverterExp = "状态")
    private String status;

    /** 删除标志（0代表存在 */
    private String delFlag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPieceName() {
        return pieceName;
    }

    public void setPieceName(String pieceName) {
        this.pieceName = pieceName;
    }

    public Long getSort() {
        return sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public String getClazz() {
        return clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }
}
