package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 场景算法块对象 algorithm_scene_piece
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmScenePiece extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 场景主键id */
    private Long sceneId;

    /** 算法块主键id */
    private Long pieceId;

    /** 算法块参数唯一标识 */
    private String variableKey;

    /** 算法块参数值 */
    @Excel(name = "算法块参数值")
    private String variableValue;

    public void setSceneId(Long sceneId) 
    {
        this.sceneId = sceneId;
    }

    public Long getSceneId() 
    {
        return sceneId;
    }
    public void setPieceId(Long pieceId) 
    {
        this.pieceId = pieceId;
    }

    public Long getPieceId() 
    {
        return pieceId;
    }
    public void setVariableKey(String variableKey) 
    {
        this.variableKey = variableKey;
    }

    public String getVariableKey() 
    {
        return variableKey;
    }
    public void setVariableValue(String variableValue) 
    {
        this.variableValue = variableValue;
    }

    public String getVariableValue() 
    {
        return variableValue;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("sceneId", getSceneId())
            .append("pieceId", getPieceId())
            .append("variableKey", getVariableKey())
            .append("variableValue", getVariableValue())
            .toString();
    }
}
