package com.ruoyi.algorithm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmSceneStatusMapper;
import com.ruoyi.algorithm.domain.AlgorithmSceneStatus;
import com.ruoyi.algorithm.service.IAlgorithmSceneStatusService;

/**
 * 算法启动摄像头配置Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmSceneStatusServiceImpl implements IAlgorithmSceneStatusService 
{
    @Autowired
    private AlgorithmSceneStatusMapper algorithmSceneStatusMapper;

    /**
     * 查询算法启动摄像头配置
     * 
     * @param algorithmKey 算法启动摄像头配置主键
     * @return 算法启动摄像头配置
     */
    @Override
    public AlgorithmSceneStatus selectAlgorithmSceneStatusByAlgorithmKey(String algorithmKey)
    {
        return algorithmSceneStatusMapper.selectAlgorithmSceneStatusByAlgorithmKey(algorithmKey);
    }

    /**
     * 查询算法启动摄像头配置列表
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 算法启动摄像头配置
     */
    @Override
    public List<AlgorithmSceneStatus> selectAlgorithmSceneStatusList(AlgorithmSceneStatus algorithmSceneStatus)
    {
        return algorithmSceneStatusMapper.selectAlgorithmSceneStatusList(algorithmSceneStatus);
    }

    /**
     * 新增算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    @Override
    public int insertAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus)
    {
        return algorithmSceneStatusMapper.insertAlgorithmSceneStatus(algorithmSceneStatus);
    }

    /**
     * 修改算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    @Override
    public int updateAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus)
    {
        return algorithmSceneStatusMapper.updateAlgorithmSceneStatus(algorithmSceneStatus);
    }

    /**
     * 批量删除算法启动摄像头配置
     * 
     * @param algorithmKeys 需要删除的算法启动摄像头配置主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmSceneStatusByAlgorithmKeys(String[] algorithmKeys)
    {
        return algorithmSceneStatusMapper.deleteAlgorithmSceneStatusByAlgorithmKeys(algorithmKeys);
    }

    /**
     * 删除算法启动摄像头配置信息
     * 
     * @param algorithmKey 算法启动摄像头配置主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmSceneStatusByAlgorithmKey(String algorithmKey)
    {
        return algorithmSceneStatusMapper.deleteAlgorithmSceneStatusByAlgorithmKey(algorithmKey);
    }
}
