package com.ruoyi.algorithm.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmScenePieceMapper;
import com.ruoyi.algorithm.domain.AlgorithmScenePiece;
import com.ruoyi.algorithm.service.IAlgorithmScenePieceService;

/**
 * 场景算法块Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmScenePieceServiceImpl implements IAlgorithmScenePieceService 
{
    @Autowired
    private AlgorithmScenePieceMapper algorithmScenePieceMapper;

    /**
     * 查询场景算法块
     * 
     * @param sceneId 场景算法块主键
     * @return 场景算法块
     */
    @Override
    public AlgorithmScenePiece selectAlgorithmScenePieceBySceneId(Long sceneId)
    {
        return algorithmScenePieceMapper.selectAlgorithmScenePieceBySceneId(sceneId);
    }

    /**
     * 查询场景算法块列表
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 场景算法块
     */
    @Override
    public List<AlgorithmScenePiece> selectAlgorithmScenePieceList(AlgorithmScenePiece algorithmScenePiece)
    {
        return algorithmScenePieceMapper.selectAlgorithmScenePieceList(algorithmScenePiece);
    }

    /**
     * 新增场景算法块
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 结果
     */
    @Override
    public int insertAlgorithmScenePiece(AlgorithmScenePiece algorithmScenePiece)
    {
        return algorithmScenePieceMapper.insertAlgorithmScenePiece(algorithmScenePiece);
    }

    /**
     * 修改场景算法块
     * 
     * @param algorithmScenePiece 场景算法块
     * @return 结果
     */
    @Override
    public int updateAlgorithmScenePiece(AlgorithmScenePiece algorithmScenePiece)
    {
        return algorithmScenePieceMapper.updateAlgorithmScenePiece(algorithmScenePiece);
    }

    /**
     * 批量删除场景算法块
     * 
     * @param sceneIds 需要删除的场景算法块主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmScenePieceBySceneIds(Long[] sceneIds)
    {
        return algorithmScenePieceMapper.deleteAlgorithmScenePieceBySceneIds(sceneIds);
    }

    /**
     * 删除场景算法块信息
     * 
     * @param sceneId 场景算法块主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmScenePieceBySceneId(Long sceneId)
    {
        return algorithmScenePieceMapper.deleteAlgorithmScenePieceBySceneId(sceneId);
    }
}
