package com.ruoyi.algorithm.service.impl;

import java.util.List;

import com.ruoyi.algorithm.domain.dto.AlgorithmSceneListDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmSceneBaseMapper;
import com.ruoyi.algorithm.domain.AlgorithmSceneBase;
import com.ruoyi.algorithm.service.IAlgorithmSceneBaseService;

/**
 * 算法场景Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmSceneBaseServiceImpl implements IAlgorithmSceneBaseService 
{
    @Autowired
    private AlgorithmSceneBaseMapper algorithmSceneBaseMapper;

    /**
     * 查询算法场景
     * 
     * @param id 算法场景主键
     * @return 算法场景
     */
    @Override
    public AlgorithmSceneBase selectAlgorithmSceneBaseById(Long id)
    {
        return algorithmSceneBaseMapper.selectAlgorithmSceneBaseById(id);
    }

    /**
     * 查询算法场景列表
     * 
     * @param algorithmSceneBase 算法场景
     * @return 算法场景
     */
    @Override
    public List<AlgorithmSceneBase> selectAlgorithmSceneBaseList(AlgorithmSceneBase algorithmSceneBase)
    {
        return algorithmSceneBaseMapper.selectAlgorithmSceneBaseList(algorithmSceneBase);
    }

    /**
     * 新增算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    @Override
    public int insertAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase)
    {
        return algorithmSceneBaseMapper.insertAlgorithmSceneBase(algorithmSceneBase);
    }

    /**
     * 修改算法场景
     * 
     * @param algorithmSceneBase 算法场景
     * @return 结果
     */
    @Override
    public int updateAlgorithmSceneBase(AlgorithmSceneBase algorithmSceneBase)
    {
        return algorithmSceneBaseMapper.updateAlgorithmSceneBase(algorithmSceneBase);
    }

    /**
     * 批量删除算法场景
     * 
     * @param ids 需要删除的算法场景主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmSceneBaseByIds(Long[] ids)
    {
        return algorithmSceneBaseMapper.deleteAlgorithmSceneBaseByIds(ids);
    }

    /**
     * 删除算法场景信息
     * 
     * @param id 算法场景主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmSceneBaseById(Long id)
    {
        return algorithmSceneBaseMapper.deleteAlgorithmSceneBaseById(id);
    }

    @Override
    public List<AlgorithmSceneListDto> selectAlgorithmSceneListDto(AlgorithmSceneBase algorithmSceneBase) {
        return algorithmSceneBaseMapper.selectAlgorithmSceneListDto(algorithmSceneBase);
    }
}
