package com.ruoyi.algorithm.service.impl;

import java.util.List;

import com.ruoyi.algorithm.domain.dto.AlgorithmCameraListDto;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.algorithm.mapper.AlgorithmCameraBaseMapper;
import com.ruoyi.algorithm.domain.AlgorithmCameraBase;
import com.ruoyi.algorithm.service.IAlgorithmCameraBaseService;

/**
 * 算法摄像头Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@Service
public class AlgorithmCameraBaseServiceImpl implements IAlgorithmCameraBaseService 
{
    @Autowired
    private AlgorithmCameraBaseMapper algorithmCameraBaseMapper;

    /**
     * 查询算法摄像头
     * 
     * @param id 算法摄像头主键
     * @return 算法摄像头
     */
    @Override
    public AlgorithmCameraBase selectAlgorithmCameraBaseById(Long id)
    {
        return algorithmCameraBaseMapper.selectAlgorithmCameraBaseById(id);
    }

    /**
     * 查询算法摄像头列表
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 算法摄像头
     */
    @Override
    public List<AlgorithmCameraBase> selectAlgorithmCameraBaseList(AlgorithmCameraBase algorithmCameraBase)
    {
        return algorithmCameraBaseMapper.selectAlgorithmCameraBaseList(algorithmCameraBase);
    }

    /**
     * 新增算法摄像头
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 结果
     */
    @Override
    public int insertAlgorithmCameraBase(AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setCreateTime(DateUtils.getNowDate());
        return algorithmCameraBaseMapper.insertAlgorithmCameraBase(algorithmCameraBase);
    }

    /**
     * 修改算法摄像头
     * 
     * @param algorithmCameraBase 算法摄像头
     * @return 结果
     */
    @Override
    public int updateAlgorithmCameraBase(AlgorithmCameraBase algorithmCameraBase)
    {
        algorithmCameraBase.setUpdateTime(DateUtils.getNowDate());
        return algorithmCameraBaseMapper.updateAlgorithmCameraBase(algorithmCameraBase);
    }

    /**
     * 批量删除算法摄像头
     * 
     * @param ids 需要删除的算法摄像头主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmCameraBaseByIds(Long[] ids)
    {
        return algorithmCameraBaseMapper.deleteAlgorithmCameraBaseByIds(ids);
    }

    /**
     * 删除算法摄像头信息
     * 
     * @param id 算法摄像头主键
     * @return 结果
     */
    @Override
    public int deleteAlgorithmCameraBaseById(Long id)
    {
        return algorithmCameraBaseMapper.deleteAlgorithmCameraBaseById(id);
    }

    @Override
    public List<AlgorithmCameraListDto> selectAlgorithmCameraListDto(AlgorithmCameraBase algorithmCameraBase) {
        return algorithmCameraBaseMapper.selectAlgorithmCameraListDto(algorithmCameraBase);
    }
}
