package com.ruoyi.algorithm.service;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmSceneStatus;

/**
 * 算法启动摄像头配置Service接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface IAlgorithmSceneStatusService 
{
    /**
     * 查询算法启动摄像头配置
     * 
     * @param algorithmKey 算法启动摄像头配置主键
     * @return 算法启动摄像头配置
     */
    public AlgorithmSceneStatus selectAlgorithmSceneStatusByAlgorithmKey(String algorithmKey);

    /**
     * 查询算法启动摄像头配置列表
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 算法启动摄像头配置集合
     */
    public List<AlgorithmSceneStatus> selectAlgorithmSceneStatusList(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 新增算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    public int insertAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 修改算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    public int updateAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 批量删除算法启动摄像头配置
     * 
     * @param algorithmKeys 需要删除的算法启动摄像头配置主键集合
     * @return 结果
     */
    public int deleteAlgorithmSceneStatusByAlgorithmKeys(String[] algorithmKeys);

    /**
     * 删除算法启动摄像头配置信息
     * 
     * @param algorithmKey 算法启动摄像头配置主键
     * @return 结果
     */
    public int deleteAlgorithmSceneStatusByAlgorithmKey(String algorithmKey);
}
