package com.ruoyi.algorithm.domain.dto;

import com.ruoyi.algorithm.domain.AlgorithmBaseType;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class AlgorithmSceneListDto {
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 场景名 */
    private String sceneName;

    /** 处理的预警类型 */
    private List<AlgorithmBaseType> alarmTypes;

    /** 每秒帧数 */
    private Long frameSecond;

    /** 摄像头 */
    private List<AlgorithmCameraListDto> cameras;

    /** 算法名称 */
    private String algorithmName;

    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    private Date createTime;

    /** 是否在线 */
    private Boolean live;

    /** 帐号状态（0正常 */
    private Boolean status;

    /** 摄像头id列表字符串 */
    private String cameraIdList;
}
