package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 算法启动摄像头配置对象 algorithm_scene_status
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmSceneStatus extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 算法key值 */
    private String algorithmKey;

    /** 场景id */
    private Long sceneId;

    /** 摄像头列表json */
    @Excel(name = "摄像头列表json")
    private String cameraList;

    /** 每秒帧数 */
    @Excel(name = "每秒帧数")
    private Long frameSecond;

    public void setAlgorithmKey(String algorithmKey) 
    {
        this.algorithmKey = algorithmKey;
    }

    public String getAlgorithmKey() 
    {
        return algorithmKey;
    }
    public void setSceneId(Long sceneId) 
    {
        this.sceneId = sceneId;
    }

    public Long getSceneId() 
    {
        return sceneId;
    }
    public void setCameraList(String cameraList) 
    {
        this.cameraList = cameraList;
    }

    public String getCameraList() 
    {
        return cameraList;
    }
    public void setFrameSecond(Long frameSecond) 
    {
        this.frameSecond = frameSecond;
    }

    public Long getFrameSecond() 
    {
        return frameSecond;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("algorithmKey", getAlgorithmKey())
            .append("sceneId", getSceneId())
            .append("cameraList", getCameraList())
            .append("frameSecond", getFrameSecond())
            .toString();
    }
}
