package com.ruoyi.algorithm.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 算法场景对象 algorithm_scene_base
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmSceneBase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 场景名 */
    @Excel(name = "场景名")
    private String sceneName;

    /** 算法id */
    @Excel(name = "算法id")
    private Long algorithmId;

    /** 处理的预警类型 */
    @Excel(name = "处理的预警类型")
    private String alarmTypes;

    /** 每秒帧数（ai算法启动参数） */
    @Excel(name = "每秒帧数", readConverterExp = "a=i算法启动参数")
    private Long frameSecond;

    /** 摄像头id列表 */
    @Excel(name = "摄像头id列表")
    private String cameraIdList;

    /** 上次在线时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上次在线时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date live;

    /** 帐号状态（0正常 */
    @Excel(name = "帐号状态", readConverterExp = "帐号状态（0正常")
    private String status;

    /** 删除标志（0代表存在 */
    private String delFlag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public Long getAlgorithmId() {
        return algorithmId;
    }

    public void setAlgorithmId(Long algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlarmTypes() {
        return alarmTypes;
    }

    public void setAlarmTypes(String alarmTypes) {
        this.alarmTypes = alarmTypes;
    }

    public Long getFrameSecond() {
        return frameSecond;
    }

    public void setFrameSecond(Long frameSecond) {
        this.frameSecond = frameSecond;
    }

    public String getCameraIdList() {
        return cameraIdList;
    }

    public void setCameraIdList(String cameraIdList) {
        this.cameraIdList = cameraIdList;
    }

    public Date getLive() {
        return live;
    }

    public void setLive(Date live) {
        this.live = live;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }
}
