package com.ruoyi.algorithm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.algorithm.domain.dto.AlgorithmSceneListDto;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.algorithm.domain.AlgorithmSceneBase;
import com.ruoyi.algorithm.service.IAlgorithmSceneBaseService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 算法场景Controller
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
@RestController
@RequestMapping("/system/algorithm/scene/base")
public class AlgorithmSceneBaseController extends BaseController
{
    @Autowired
    private IAlgorithmSceneBaseService algorithmSceneBaseService;

    /**
     * 查询算法场景列表
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmScene:list')")
    @GetMapping("/list")
    public TableDataInfo list(AlgorithmSceneBase algorithmSceneBase)
    {
        startPage();
        List<AlgorithmSceneListDto> list = algorithmSceneBaseService.selectAlgorithmSceneListDto(algorithmSceneBase);
        return getDataTable(list);
    }

    /**
     * 获取算法场景详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmScene:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(algorithmSceneBaseService.selectAlgorithmSceneBaseById(id));
    }

    /**
     * 新增算法场景
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmScene:add')")
    @Log(title = "算法场景", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AlgorithmSceneBase algorithmSceneBase)
    {
        return toAjax(algorithmSceneBaseService.insertAlgorithmSceneBase(algorithmSceneBase));
    }

    /**
     * 修改算法场景
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmScene:edit')")
    @Log(title = "算法场景", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AlgorithmSceneBase algorithmSceneBase)
    {
        return toAjax(algorithmSceneBaseService.updateAlgorithmSceneBase(algorithmSceneBase));
    }

    /**
     * 删除算法场景
     */
    @PreAuthorize("@ss.hasPermi('system:algorithmScene:remove')")
    @Log(title = "算法场景", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(algorithmSceneBaseService.deleteAlgorithmSceneBaseByIds(ids));
    }
}
