package com.ruoyi.algorithm.mapper;

import java.util.List;

import com.ruoyi.algorithm.domain.AlgorithmSceneBase;
import com.ruoyi.algorithm.domain.AlgorithmSceneStatus;
import com.ruoyi.algorithm.domain.dto.AlgorithmSceneStatusCameraListDto;
import org.apache.ibatis.annotations.Param;

/**
 * 算法启动摄像头配置Mapper接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface AlgorithmSceneStatusMapper 
{
    /**
     * 查询算法启动摄像头配置
     * 
     * @param algorithmKey 算法启动摄像头配置主键
     * @return 算法启动摄像头配置
     */
    public AlgorithmSceneStatus selectAlgorithmSceneStatusByAlgorithmKey(String algorithmKey);

    /**
     * 查询算法启动摄像头配置列表
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 算法启动摄像头配置集合
     */
    public List<AlgorithmSceneStatus> selectAlgorithmSceneStatusList(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 新增算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    public int insertAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 修改算法启动摄像头配置
     * 
     * @param algorithmSceneStatus 算法启动摄像头配置
     * @return 结果
     */
    public int updateAlgorithmSceneStatus(AlgorithmSceneStatus algorithmSceneStatus);

    /**
     * 删除算法启动摄像头配置
     * 
     * @param sceneId 场景id
     * @return 结果
     */
    public int deleteAlgorithmSceneStatusBySceneId(@Param("sceneId") Long sceneId);

    public AlgorithmSceneStatus selectAlgorithmSceneBase(@Param("sceneId") Long sceneId);

    public List<AlgorithmSceneStatusCameraListDto> selectCameraList(@Param("sceneId") Long sceneId);
}
