package com.ruoyi.algorithm.domain.dto;

import lombok.Data;

import java.util.List;

@Data
public class AlgorithmSceneDetailsDto {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 场景名
     */
    private String sceneName;

    /**
     * 算法id
     */
    private Long algorithmId;

    /**
     * 处理的预警类型
     */
    private String alarmTypes;

    /**
     * 每秒帧数（ai算法启动参数）
     */
    private Long frameSecond;

    /**
     * 摄像头id列表
     */
    private String cameraIdList;


    private List<AlgorithmPieceDetailsDto> pieceDtos;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 更新者
     */
    private String updateBy;
}
