package com.ruoyi.algorithm.service;

import java.util.List;
import com.ruoyi.algorithm.domain.AlgorithmPieceBase;
import com.ruoyi.algorithm.domain.dto.AlgorithmPieceListDto;

/**
 * 策略算法块Service接口
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public interface IAlgorithmPieceBaseService 
{
    /**
     * 查询策略算法块
     * 
     * @param id 策略算法块主键
     * @return 策略算法块
     */
    public AlgorithmPieceBase selectAlgorithmPieceBaseById(Long id);

    /**
     * 查询策略算法块列表
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 策略算法块集合
     */
    public List<AlgorithmPieceBase> selectAlgorithmPieceBaseList(AlgorithmPieceBase algorithmPieceBase);

    /**
     * 新增策略算法块
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 结果
     */
    public int insertAlgorithmPieceBase(AlgorithmPieceBase algorithmPieceBase);

    /**
     * 修改策略算法块
     * 
     * @param algorithmPieceBase 策略算法块
     * @return 结果
     */
    public int updateAlgorithmPieceBase(AlgorithmPieceBase algorithmPieceBase);

    /**
     * 批量删除策略算法块
     * 
     * @param ids 需要删除的策略算法块主键集合
     * @return 结果
     */
    public int deleteAlgorithmPieceBaseByIds(Long[] ids);

    /**
     * 删除策略算法块信息
     * 
     * @param id 策略算法块主键
     * @return 结果
     */
    public int deleteAlgorithmPieceBaseById(Long id);

    List<AlgorithmPieceListDto> selectAlgorithmPieceListDto(AlgorithmPieceBase algorithmPieceBase);
}
