package com.ruoyi.algorithm.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 算法预警类型对象 algorithm_base_type
 * 
 * @author ruoyi
 * @date 2023-04-26
 */
public class AlgorithmBaseType extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 算法主键id */
    private Long algorithmId;

    /** 预警唯一标识 */
    private String typeKey;

    /** 预警名称 */
    @Excel(name = "预警名称")
    private String typeName;

    public void setAlgorithmId(Long algorithmId) 
    {
        this.algorithmId = algorithmId;
    }

    public Long getAlgorithmId() 
    {
        return algorithmId;
    }
    public void setTypeKey(String typeKey) 
    {
        this.typeKey = typeKey;
    }

    public String getTypeKey() 
    {
        return typeKey;
    }
    public void setTypeName(String typeName) 
    {
        this.typeName = typeName;
    }

    public String getTypeName() 
    {
        return typeName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("algorithmId", getAlgorithmId())
            .append("typeKey", getTypeKey())
            .append("typeName", getTypeName())
            .toString();
    }
}
