package com.censoft.flink;

import com.alibaba.fastjson2.JSON;
import com.censoft.flink.domain.*;
import com.censoft.flink.mapper.SqlFactory;
import com.censoft.flink.mqtt.MqttConsumer;
import com.censoft.flink.transform.AlgorithmBaseFilterFunction;
import com.censoft.flink.transform.AlgorithmTypeFlatMapFunction;
import com.censoft.flink.transform.ResultExistFilterFunction;
import com.censoft.flink.transform.UpdateLiveFilterFunction;
import com.censoft.flink.utils.RtspToMP4;
import com.dahuatech.hutool.json.JSONObject;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.DefaultClient;
import com.dahuatech.icc.oauth.http.IClient;
import com.dahuatech.icc.oauth.model.v202010.GeneralRequest;
import com.dahuatech.icc.oauth.model.v202010.GeneralResponse;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;


public class StreamingJob {

    public static void main(String[] args) throws Exception {
        //1.获取对应场景id
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        Long sceneId = parameterTool.getLong("sceneId");

        //2.获取对应算法参数
        //2.1 获取场景数据
        SqlFactory sqlFactory = new SqlFactory();
        AlgorithmSceneBasePo algorithmSceneBasePo = sqlFactory.getAlgorithmSceneBasePo(sceneId);

        //2.2 获取场景算法块数据
        List<AlgorithmScenePiecePo> algorithmScenePieceList = sqlFactory.getAlgorithmScenePieceList(sceneId);

        //2.3 获取算法列表
        List<AlgorithmPo> algorithmPoList = sqlFactory.getAlgorithmPoList();

        //2.4 获取摄像头列表
        List<AlgorithmCameraPo> algorithmCameraPoList = sqlFactory.getAlgorithmCameraPoList();


        //1、创建流式执行环境
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);


        //2、接收消息并将数据转化为流
        //根据场景id 拼接对应的mqtt频道名称
        DataStream<AlgorithmPushDto> mqttStream = env.addSource(new MqttConsumer("/censoft/cpptest/" + (sceneId - 1)));

        //3、进行处理
        //3、0 更新场景在线时间
        SingleOutputStreamOperator<AlgorithmPushDto> streamOperator = mqttStream
                .filter(new UpdateLiveFilterFunction(sceneId));

        //3、1 默认 是否存在结果集判断
        streamOperator = streamOperator
                .filter(new ResultExistFilterFunction());

        //3、2 默认 根据分类,分解多个推送信息
        List<String> algorithmTypes = Arrays.asList(algorithmSceneBasePo.getAlarmTypes().split(","));
        streamOperator = streamOperator.flatMap(new AlgorithmTypeFlatMapFunction(algorithmTypes));


        //3、3 根据配置算法流程 反射对应对象
        for (AlgorithmScenePiecePo algorithmScenePiecePo : algorithmScenePieceList) {
            //通过构造函数 获取算法块对象
            Class<?> filterClazz = Class.forName(algorithmScenePiecePo.getClazz());
            Method method = filterClazz.getMethod("getFilterFunction", AlgorithmSceneBasePo.class, AlgorithmScenePiecePo.class);
            AlgorithmBaseFilterFunction filterFunction = (AlgorithmBaseFilterFunction) method.invoke(null, algorithmSceneBasePo, algorithmScenePiecePo);
            streamOperator = streamOperator.filter(filterFunction);
        }

        //3、4 Object -> String
        SingleOutputStreamOperator<String> outputStreamOperator = streamOperator.map(algorithmPushDto -> {
            AlgorithmWarnPushDto warnPushBase = new AlgorithmWarnPushDto();
            warnPushBase.setOrderName("AI预警平台");
            //获取摄像头名称
            warnPushBase.setAlarmDeviceName(getAlgorithmCameraPoByRtsp(algorithmCameraPoList,algorithmPushDto.getCameraName())
                    .getCameraName());
            //获取摄像头归属
            warnPushBase.setBelong(getAlgorithmCameraPoByRtsp(algorithmCameraPoList,algorithmPushDto.getCameraName())
                    .getBelong());
            warnPushBase.setGradeName("二级预警");
            //获取摄像头名称
            warnPushBase.setGradeType(getAlgorithmPoById(algorithmPoList,Long.valueOf(algorithmPushDto.getAlgorithmName()))
                    .getAlgorithmName());
            warnPushBase.setAlarmTime(new Date(algorithmPushDto.getTimeStamp() * 1000));
            //获取图片地址
            warnPushBase.setPicture("http://172.16.21.3"+algorithmPushDto.getPictureAddress());
            //获取视频地址
            warnPushBase.setVideo(getVideo("1000790$1$0$0",1698868554L,1698868654L));
            warnPushBase.setStatus("wait");
            warnPushBase.setSendUserIds("|1|");
            warnPushBase.setDelFlag(0);
            warnPushBase.setRemark(algorithmPushDto.getRemark());
            return JSON.toJSONString(warnPushBase);
        });

        //3、5 输出kafka
        outputStreamOperator.addSink(new FlinkKafkaProducer("172.16.33.152:9092", "test-topic", new SimpleStringSchema()));

        //3、6 打印输出
        outputStreamOperator.print();
        outputStreamOperator.writeAsText("F:/word" + sceneId + ".txt", FileSystem.WriteMode.OVERWRITE).setParallelism(1);
        //3、7 自动执行
        env.execute();
    }


    private static AlgorithmCameraPo getAlgorithmCameraPoByRtsp(List<AlgorithmCameraPo> cameraPos, String rtsp) {
        return cameraPos
                .stream()
                .filter(cameraPo -> rtsp.equals(cameraPo.getRtsp())).findFirst().get();
    }


    private static AlgorithmPo getAlgorithmPoById(List<AlgorithmPo> algorithmPos, Long id) {
        return algorithmPos
                .stream()
                .filter(algorithmPo -> id.equals(algorithmPo.getId())).findFirst().get();
    }


    private static String getVideo(String channelId, Long startTime, Long endTime) {
        try {
            //获取录像视频流
            String rtsp = rtsp(channelId, startTime, endTime);

            //视频流转mp4
            String filePath = "F:\\data\\MP4\\1.mp4";
            RtspToMP4.StartRecord("F:\\ffmpeg\\ffmpeg-2023-10-29-git-2532e832d2-full_build\\bin\\ffmpeg.exe",rtsp,filePath);
            return filePath;
        } catch (ClientException e) {
            e.printStackTrace();
        }

        return "";
    }

    private static String rtsp(String channelId, Long startTime, Long endTime) throws ClientException {
        IClient iClient = new DefaultClient();
        GeneralRequest generalRequest =
                new GeneralRequest("/evo-apigw/admin/API/SS/Playback/StartPlaybackByFile", com.dahuatech.hutool.http.Method.POST);
        String body =
                "{\n" +
                        "  \"data\": {\n" +
                        "    \"channelId\": \"" + channelId + "\",\n" +
                        "    \"recordSource\": \"3\",\n" +
                        "    \"startTime\": \"" + startTime + "\",\n" +
                        "    \"endTime\": \"" + endTime + "\",\n" +
                        "    \"streamType\": \"1\",\n" +
                        "    \"recordType\": \"1\"\n" +
                        "  }\n" +
                        "}";
        generalRequest.body(body);
        GeneralResponse response = iClient.doAction(generalRequest, generalRequest.getResponseClass());
        String result = response.getResult();
        JSONObject obj = JSONUtil.parseObj(response.getResult());
        String url = obj.getJSONObject("data").getStr("url");
        String token = obj.getJSONObject("data").getStr("token");
        String[] parts = url.split("\\|");
        return parts[0] + "?token=" + token+"&trackID=0";
    }
}
