package com.censoft.flink.transform;

import com.censoft.flink.domain.AlgorithmPushDto;
import com.censoft.flink.mapper.SqlFactory;

import java.io.IOException;

/**
 * @author 周昊
 * @desc 更新场景存活时间
 */
public class UpdateLiveFilterFunction implements AlgorithmBaseFilterFunction {

    //sceneId 场景id
    private final Long sceneId;

    public UpdateLiveFilterFunction(Long sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public boolean filter(AlgorithmPushDto algorithmPushDto) throws IOException {
        SqlFactory sqlFactory = new SqlFactory();
        sqlFactory.updateLiveBySceneId(sceneId);
        return true;
    }
}
