package com.censoft.flink.mapper;

import com.censoft.flink.domain.AlgorithmSceneBasePo;
import com.censoft.flink.domain.AlgorithmScenePiecePo;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * @author 周昊
 * @desc ...
 * @date 2023-04-18 13:50:32
 */
public class SqlFactory {

    public AlgorithmSceneBasePo getAlgorithmSceneBasePo(Long sceneId) throws IOException {
        SqlSession session = initSqlSession();
        //指定要执行的SQL语句的id
        //SQL语句的id=namespace+"."+SQL语句所在标签的id属性的值
        String SQLID = "com.censoft.flink.mapper.AlgorithmSceneDao" + "." + "getAlgorithmSceneBasePo";
        //通过SqlSession对象的方法执行SQL语句
        AlgorithmSceneBasePo algorithmSceneBasePo = session.selectOne(SQLID,sceneId);
        //最后我们关闭SqlSession对象
        session.close();
        return algorithmSceneBasePo;
    }

    public List<AlgorithmScenePiecePo> getAlgorithmScenePieceList(Long sceneId) throws IOException {
        SqlSession session = initSqlSession();
        //指定要执行的SQL语句的id
        //SQL语句的id=namespace+"."+SQL语句所在标签的id属性的值
        String SQLID = "com.censoft.flink.mapper.AlgorithmSceneDao" + "." + "getAlgorithmScenePieceList";
        //通过SqlSession对象的方法执行SQL语句
        List<AlgorithmScenePiecePo> algorithmScenePiecePoList = session.selectList(SQLID,sceneId);
        //最后我们关闭SqlSession对象
        session.close();
        return algorithmScenePiecePoList;
    }

    public int updateLiveBySceneId(Long sceneId) throws IOException {
        SqlSession session = initSqlSession();
        //指定要执行的SQL语句的id
        //SQL语句的id=namespace+"."+SQL语句所在标签的id属性的值
        String SQLID = "com.censoft.flink.mapper.AlgorithmSceneDao" + "." + "updateLiveBySceneId";
        //通过SqlSession对象的方法执行SQL语句
        int result = session.update(SQLID,sceneId);
        //提交事务
        session.commit();
        //最后我们关闭SqlSession对象
        session.close();
        return result;
    }

    private SqlSession initSqlSession() throws IOException {
        /*
        myBatis的核心类是SqlSessionFactory
        就是需要我们加载一下主配置文件，有点像我们使用SpringMVC加载spring.xml配置文件或者BeanFactory对象一样。
        这些在官网是有的。
         */
        //定义主配置文件的目录，从类路径开始：com/**/**这样的，如果是在resources目录下，那就是 **/**/
        String config = "mybatis.xml";
        //下面读取主配置文件，使用MyBatis框架中的Resources类
        InputStream inputStream = Resources.getResourceAsStream(config);
        //下面创建SqlSessionFactory对象，使用的是SqlSessionFactoryBuilder类，需要用到上面的inputStream参数
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
        //MyBatis最终执行SQL语句，使用的是SqlSession类中的方法。SqlSession实例的获得，依靠的是SqlSessionFactory类。
        //下面获取SqlSession对象，SqlSession是接口
        return sqlSessionFactory.openSession();
    }

}
