package com.censoft.flink.transform;

import cn.hutool.core.util.NumberUtil;
import com.censoft.flink.domain.AlgorithmPushDto;
import com.censoft.flink.domain.AlgorithmSceneBasePo;
import com.censoft.flink.domain.AlgorithmScenePiecePo;
import com.censoft.flink.domain.AlgorithmScenePieceVariablePo;
import com.censoft.flink.exception.ParameterTransformException;

import java.util.Optional;

/**
 * @author 周昊
 * @desc 人员脱岗超员算法筛选
 */
public class PersonNumberMinFilterFunction implements AlgorithmBaseFilterFunction {


    //personNumberMin 最少人员数量
    private final Integer personNumberMin;


    //最少人员数量 参数KEY
    private static String personNumberMinKey = "person_number_min";

    public PersonNumberMinFilterFunction( Integer personNumberMin) {
        this.personNumberMin = personNumberMin;
    }

    public static PersonNumberMinFilterFunction getFilterFunction(AlgorithmSceneBasePo algorithmSceneBasePo, AlgorithmScenePiecePo algorithmScenePiecePo) {

        //参数准备
        Optional<AlgorithmScenePieceVariablePo> minVariablePo = algorithmScenePiecePo.getVariablePos()
                .stream()
                .filter(po -> personNumberMinKey.equals(po.getVariableKey()))
                .findFirst();

        //判断参数是否存在，如果不存在抛出异常
        if ( !minVariablePo.isPresent()) {
            throw new ParameterTransformException();
        }
        Integer personNumberMin = Integer.valueOf(minVariablePo.get().getVariableValue());

        return new PersonNumberMinFilterFunction(personNumberMin);
    }

    @Override
    public boolean filter(AlgorithmPushDto algorithmPushDto) {
        //判断是否为0/1的情况
        int personNumber;
        if (algorithmPushDto.getResult().size() == 1 ){
            String remark = algorithmPushDto.getResult().get(0).getRemark();
            if(NumberUtil.isInteger(remark)){
                personNumber = Integer.valueOf(remark);
            }else {
                personNumber = 0;
            }
        }else {
            personNumber = algorithmPushDto.getResult().size();
        }

        if (personNumber <= personNumberMin) {
            algorithmPushDto.setRemark("人员脱岗，人员数量:" + personNumber);
            return true;
        }
        return false;
    }
}
