package com.censoft.flink.transform;

import cn.hutool.core.util.NumberUtil;
import com.censoft.flink.domain.AlgorithmPushDto;
import com.censoft.flink.domain.AlgorithmSceneBasePo;
import com.censoft.flink.domain.AlgorithmScenePiecePo;
import com.censoft.flink.domain.AlgorithmScenePieceVariablePo;
import com.censoft.flink.exception.ParameterTransformException;

import java.util.Optional;

/**
 * @author 周昊
 * @desc 人员脱岗超员算法筛选
 */
public class PersonNumberMaxFilterFunction implements AlgorithmBaseFilterFunction {

    //personNumberMax 最多人员数量
    private final Integer personNumberMax;

    //最多人员数量 参数KEY
    private static String personNumberMaxKey = "person_number_max";


    public PersonNumberMaxFilterFunction(Integer personNumberMax) {
        this.personNumberMax = personNumberMax;
    }

    public static PersonNumberMaxFilterFunction getFilterFunction(AlgorithmSceneBasePo algorithmSceneBasePo, AlgorithmScenePiecePo algorithmScenePiecePo) {
        //参数准备
        Optional<AlgorithmScenePieceVariablePo> maxVariablePo = algorithmScenePiecePo.getVariablePos()
                .stream()
                .filter(po -> personNumberMaxKey.equals(po.getVariableKey()))
                .findFirst();

        //判断参数是否存在，如果不存在抛出异常
        if (!maxVariablePo.isPresent() ) {
            throw new ParameterTransformException();
        }
        Integer personNumberMax = Integer.valueOf(maxVariablePo.get().getVariableValue());

        return new PersonNumberMaxFilterFunction(personNumberMax);
    }

    @Override
    public boolean filter(AlgorithmPushDto algorithmPushDto) {
        //判断是否为0/1的情况
        int personNumber;
        if (algorithmPushDto.getResult().size() == 1 ){
            String remark = algorithmPushDto.getResult().get(0).getRemark();
            if(NumberUtil.isInteger(remark)){
                personNumber = Integer.valueOf(remark);
            }else {
                personNumber = 0;
            }
        }else {
            personNumber = algorithmPushDto.getResult().size();
        }


        if (personNumber >= personNumberMax) {
            algorithmPushDto.setRemark("人员超岗，人员数量:" + personNumber);
            return true;
        }
        return false;
    }
}
