package com.censoft.flink.transform;

import com.censoft.flink.domain.AlgorithmPushDto;
import com.censoft.flink.domain.AlgorithmPushResultBoxDto;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author 周昊
 * @desc ...
 */
public class AlgorithmTypeFlatMapFunction implements FlatMapFunction<AlgorithmPushDto, AlgorithmPushDto> {

    private List<String> algorithmTypes;

    private static Logger logger = LogManager.getLogger(AlgorithmTypeFlatMapFunction.class.getName());


    @Override
    public void flatMap(AlgorithmPushDto algorithmPushDto, Collector<AlgorithmPushDto> collector) {
        //1、筛选所配置的预警label的Key值
        //2、将相同label的Key值分出多个预警

        List<AlgorithmPushResultBoxDto> boxDtos = algorithmPushDto.getResult();
//        System.out.println(algorithmPushDto.toString());

        List<String> types = boxDtos
                .stream()
                .filter(result -> {
                    String label = result.getLabel();
                    String type = label.substring(0, label.indexOf("_"));
                    return algorithmTypes.contains(type);
                })
                .map(result -> {
                    String label = result.getLabel();
                    return label.substring(0, label.indexOf("_"));
                })
                .distinct()
                .collect(Collectors.toList());

        for (String type : types) {

            AlgorithmPushDto pushDto = new AlgorithmPushDto();
            pushDto.setAlgorithmName(algorithmPushDto.getAlgorithmName());
            pushDto.setCameraName(algorithmPushDto.getCameraName());
            pushDto.setCameraUrl(algorithmPushDto.getCameraUrl());
            pushDto.setPictureAddress(algorithmPushDto.getPictureAddress());
            pushDto.setSort(algorithmPushDto.getSort());
            pushDto.setTimeStamp(algorithmPushDto.getTimeStamp());
            pushDto.setServerIp(algorithmPushDto.getServerIp());
            pushDto.setRemark(algorithmPushDto.getRemark());

            pushDto.setAlgorithmType(type);

            List<AlgorithmPushResultBoxDto> result = boxDtos.stream().filter(boxDto -> {
                String label = boxDto.getLabel();
                return label.substring(0, label.indexOf("_")).equals(type);
            }).collect(Collectors.toList());

            pushDto.setResult(result);

            collector.collect(pushDto);
        }

    }

    public AlgorithmTypeFlatMapFunction(List<String> algorithmTypes) {
        this.algorithmTypes = algorithmTypes;
    }

    public AlgorithmTypeFlatMapFunction() {
    }


}
