package com.censoft.flink.transform;

import com.censoft.flink.domain.AlgorithmPushDto;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 周昊
 * @desc ...
 */
public class AlgorithmTypeFlatMapFunction implements FlatMapFunction<AlgorithmPushDto, AlgorithmPushDto> {

    private List<String> algorithmTypes;

    private static Logger logger = LogManager.getLogger(AlgorithmTypeFlatMapFunction.class.getName());


    @Override
    public void flatMap(AlgorithmPushDto algorithmPushDto, Collector<AlgorithmPushDto> collector) {

        List<AlgorithmPushDto> collect = algorithmPushDto.getResult()
                .stream()
                .filter(result -> {
                    String label = result.getLabel();
                    String type = label.substring(0, label.indexOf("_"));
                    return algorithmTypes.contains(type);
                })
                .map(result -> {
                    //复制
                    AlgorithmPushDto pushDto = new AlgorithmPushDto();
                    pushDto.setAlgorithmName(algorithmPushDto.getAlgorithmName());
                    pushDto.setCameraName(algorithmPushDto.getCameraName());
                    pushDto.setCameraUrl(algorithmPushDto.getCameraUrl());
                    pushDto.setPictureAddress(algorithmPushDto.getPictureAddress());
                    pushDto.setSort(algorithmPushDto.getSort());
                    pushDto.setTimeStamp(algorithmPushDto.getTimeStamp());

                    String label = result.getLabel();
                    String type = label.substring(0, label.indexOf("_"));
                    pushDto.setAlgorithmType(type);
                    pushDto.setResult(Collections.singletonList(result));
                    return pushDto;
                }).collect(Collectors.toList());

        for (AlgorithmPushDto pushDto : collect) {
            collector.collect(pushDto);
        }

    }

    public AlgorithmTypeFlatMapFunction(List<String> algorithmTypes) {
        this.algorithmTypes = algorithmTypes;
    }

    public AlgorithmTypeFlatMapFunction() {
    }


}
