import request from '@/utils/request'

// 查询算法预警类型列表
export function listType(query) {
  return request({
    url: '/system/type/list',
    method: 'get',
    params: query
  })
}

// 查询算法预警类型详细
export function getType(algorithmId) {
  return request({
    url: '/system/type/' + algorithmId,
    method: 'get'
  })
}

// 新增算法预警类型
export function addType(data) {
  return request({
    url: '/system/type',
    method: 'post',
    data: data
  })
}

// 修改算法预警类型
export function updateType(data) {
  return request({
    url: '/system/type',
    method: 'put',
    data: data
  })
}

// 删除算法预警类型
export function delType(algorithmId) {
  return request({
    url: '/system/type/' + algorithmId,
    method: 'delete'
  })
}
