import request from '@/utils/request'

// 查询算法场景列表
export function listBase(query) {
  return request({
    url: '/system/algorithm/scene/base/list',
    method: 'get',
    params: query
  })
}

// 查询算法场景详细
export function getBase(id) {
  return request({
    url: '/system/algorithm/scene/base/' + id,
    method: 'get'
  })
}

// 新增算法场景
export function addBase(data) {
  return request({
    url: '/system/algorithm/scene/base',
    method: 'post',
    data: data
  })
}

// 修改算法场景
export function updateBase(data) {
  return request({
    url: '/system/algorithm/scene/base',
    method: 'put',
    data: data
  })
}

// 删除算法场景
export function delBase(id) {
  return request({
    url: '/system/algorithm/scene/base/' + id,
    method: 'delete'
  })
}

// 获取算法场景
export function sceneList(id) {
  return request({
    url: '/system/algorithm/base/list/all',
    method: 'get'
  })
}

// 获取分流预警类型
export function typeList(id) {
  return request({
    url: '/system/algorithm/type/list/' + id,
    method: 'get'
  })
}

// 获取摄像头列表
export function cameraList() {
  return request({
    url: '/system/algorithm/camera/base/list/all',
    method: 'get'
  })
}

// 获取算法块名称
export function pieceList() {
  return request({
    url: '/system/algorithm/piece/base/list/all',
    method: 'get'
  })
}
// 获取算法块名称
export function variableList(id) {
  return request({
    url: '/system/algorithm/piece/variable/list/'+id,
    method: 'get'
  })
}
// 复制算法
export function copyAlgorithm(id) {
  return request({
    url: '/system/algorithm/scene/base/'+id,
    method: 'post'
  })
}
// 复制算法
export function editStatus(data) {
  return request({
    url: '/system/algorithm/scene/base/editStatus',
    method: 'put',
    data: data
  })
}
