import request from '@/utils/request'

// 查询算法摄像头列表
export function listBase(query) {
  return request({
    url: '/system/algorithm/camera/base/list',
    method: 'get',
    params: query
  })
}

// 查询算法摄像头详细
export function getBase(id) {
  return request({
    url: '/system/algorithm/camera/base/' + id,
    method: 'get'
  })
}

// 新增算法摄像头
export function addBase(data) {
  return request({
    url: '/system/algorithm/camera/base',
    method: 'post',
    data: data
  })
}

// 修改算法摄像头
export function updateBase(data) {
  return request({
    url: '/system/algorithm/camera/base',
    method: 'put',
    data: data
  })
}

// 删除算法摄像头
export function delBase(id) {
  return request({
    url: '/system/algorithm/camera/base/' + id,
    method: 'delete'
  })
}
