import request from '@/utils/request'

// 查询算法列表
export function listBase(query) {
  return request({
    url: '/system/algorithm/base/list',
    method: 'get',
    params: query
  })
}

// 查询算法详细
export function getBase(id) {
  return request({
    url: '/system/algorithm/base/' + id,
    method: 'get'
  })
}

// 新增算法
export function addBase(data) {
  return request({
    url: '/system/algorithm/base',
    method: 'post',
    data: data
  })
}

// 修改算法
export function updateBase(data) {
  return request({
    url: '/system/algorithm/base',
    method: 'put',
    data: data
  })
}

// 删除算法
export function delBase(id) {
  return request({
    url: '/system/algorithm/base/' + id,
    method: 'delete'
  })
}
