import request from '@/utils/request'

// 查询策略算法块列表
export function listBase(query) {
  return request({
    url: '/system/algorithm/piece/base/list',
    method: 'get',
    params: query
  })
}

// 查询策略算法块详细
export function getBase(id) {
  return request({
    url: '/system/algorithm/piece/base/' + id,
    method: 'get'
  })
}

// 新增策略算法块
export function addBase(data) {
  return request({
    url: '/system/algorithm/piece/base',
    method: 'post',
    data: data
  })
}

// 修改策略算法块
export function updateBase(data) {
  return request({
    url: '/system/algorithm/piece/base',
    method: 'put',
    data: data
  })
}

// 删除策略算法块
export function delBase(id) {
  return request({
    url: '/system/algorithm/piece/base/' + id,
    method: 'delete'
  })
}
