/** 
 * 新增算法预警信息
 * @param {object} params 算法预警信息
 * @param {string} params.alarmImg 预警图片
 * @param {number} params.alarmLevelId 预警等级id
 * @param {object} params.alarmTime 预警时间
 * @param {string} params.alarmType 预警类型
 * @param {number} params.algorithmId 算法id
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {number} params.deviceId 设备id
 * @param {number} params.id 主键
 * @param {object} params.params 
 * @param {number} params.regionId 区域id
 * @param {string} params.remark 
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @returns
 */
import request from '@/utils/request'

// 查询算法预警
export function listAlarm(query) {
    return request({
      url: '/yunshou/aiAlgorithmAlarm/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法预警x详情
export function detailAlarm(id) {
    return request({
      url: `/yunshou/aiAlgorithmAlarm/${id}`,
      method: 'get',
    })
  }
  

// 新增算法预警
export function addAlarm(data) {
  return request({
    url: '/yunshou/aiAlgorithmAlarm',
    method: 'post',
    data: data 
  })
}

// 修改算法预警
export function updateAlarm(data) {
    return request({
      url: '/yunshou/aiAlgorithmAlarm',
      method: 'put',
      data: data
    })
  }
  

// 删除算法预警
export function deleteAlarm(ids) {
  return request({
    url: `/yunshou/aiAlgorithmAlarm/${ids}`,
    method: 'delete'
  })
}
