/** 
 * 新增设备
 * @param {object} params 设备表
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {object} params.params 
 * @param {string} params.remark 
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @param {string} params.id 主键ID
 * @param {string} params.deviceNo 设备编号
 * @param {string} params.deviceName 设备名称
 * @param {string} params.deviceType 设备类型
 * @param {string} params.videoUrlType 视频流类型
 * @param {string} params.videoUrl 视频流地址
 * @param {string} params.isDel 是否删除（0 正常 / 1 删除）
 * @param {string} params.isEffective 是否有效（0 有效 / 1 无效）
 * @param {string} params.isOpen 开启状态（0 开启 / 1 关闭）
 * @returns
 */
import request from '@/utils/request'

// 查询设备列表
export function listDevice(query) {
    return request({
      url: '/yunshou/aiDevice/list',
      method: 'get',
      params: query
    })
  }
  
// 查询设备列表x详情
export function detailDevice(id) {
    return request({
      url: `/yunshou/aiDevice/${id}`,
      method: 'get',
    })
  }

// 修改设备状态
export function updateStatusDevice(query) {
    return request({
      url: `/yunshou/aiDevice/updateStatus`,
      method: 'get',
      params: query
    })
  }
  

// 新增设备列表
export function addDevice(data) {
  return request({
    url: '/yunshou/aiDevice',
    method: 'post',
    data: data
  })
}

// 修改设备列表
export function updateDevice(data) {
    return request({
      url: '/yunshou/aiDevice',
      method: 'put',
      data: data
    })
  }
  

// 删除设备列表
export function deleteDevice(ids) {
  return request({
    url: `/yunshou/aiDevice/${ids}`,
    method: 'delete'
  })
}

// 导出设备列表
export function exportDevice(data) {
  return request({
    url: `/yunshou/aiDevice/export`,
    method: 'post',
    data: data
  })
}
