/** 
 * 查询算法日志信息列表
 * @param {string} algorrithmName 
  * @param {string} cameraNo 
  * @param {string} costTime 
  * @param {string} createBy 
  * @param {string} createTime 
  * @param {string} jsonResult 
  * @param {string} operId 
  * @param {string} operParam 
  * @param {string} operTime 
  * @param {string} params 
  * @param {string} remark 
  * @param {string} searchValue 
  * @param {string} status 
  * @param {string} updateBy 
  * @param {string} updateTime 
  * @returns
 */
import request from '@/utils/request'

// 查询摄像头日志列表
export function listCameraLog(query) {
    return request({
      url: '/test/cameraLog/list',
      method: 'get',
      params: query
    })
  }

// 查询算法日志列表
export function listAlgLog(query) {
    return request({
      url: '/test/algorithmLog/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法日志列表x详情
export function detailAlgLog(id) {
    return request({
      url: `/test/algorithmLog/${id}`,
      method: 'get',
    })
  }

// 修改算法日志状态
export function updateStatusAlgLog(query) {
    return request({
      url: `/test/algorithmLog/updateStatus`,
      method: 'get',
      params: query
    })
  }
  

// 新增算法日志列表
export function addAlgLog(data) {
  return request({
    url: '/test/algorithmLog',
    method: 'post',
    data: data
  })
}

// 修改算法日志列表
export function updateAlgLog(data) {
    return request({
      url: '/test/algorithmLog',
      method: 'put',
      data: data
    })
  }
  

// 删除算法日志列表
export function deleteAlgLog(ids) {
  return request({
    url: `/test/algorithmLog/${ids}`,
    method: 'delete'
  })
}

// 导出算法日志列表
export function exportAlgLog(data) {
  return request({
    url: `/test/algorithmLog/export`,
    method: 'post',
    data: data
  })
}
