/** 
/** 
 * 新增算法场景
 * @param {object} params 算法场景
 * @param {number} params.algorithmId 算法id
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {number} params.id 主键
 * @param {object} params.params 
 * @param {string} params.remark 
 * @param {string} params.sceneDetail 场景详情
 * @param {string} params.sceneName 场景名称
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @returns
 */
import request from '@/utils/request'

// 查询算法列表
export function listScene(query) {
    return request({
      url: '/yunshou/aiAlgorithmScene/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法列表x详情
export function detailScene(id) {
    return request({
      url: `/yunshou/aiAlgorithmScene/${id}`,
      method: 'get',
    })
  }
  

// 新增算法列表
export function addScene(data) {
  return request({
    url: '/yunshou/aiAlgorithmScene',
    method: 'post',
    data: data
  })
}

// 修改算法列表
export function updateScene(data) {
    return request({
      url: '/yunshou/aiAlgorithmScene',
      method: 'put',
      data: data
    })
  }
  

// 删除算法列表
export function deleteScene(ids) {
  return request({
    url: `/yunshou/aiAlgorithmScene/${ids}`,
    method: 'delete'
  })
}
