/** 
/** 
 * 新增算法边界场景
 * @param {object} params 算法边界场景
 * @param {number} params.algorithmId 算法边界id
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {number} params.id 主键
 * @param {object} params.params 
 * @param {string} params.remark 
 * @param {string} params.sceneDetail 场景详情
 * @param {string} params.sceneName 场景名称
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @returns
 */
import request from '@/utils/request'

// 查询算法边界列表
export function listBoundary(query) {
    return request({
      url: '/yunshou/aiAlgorithmCase/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法边界列表x详情
export function detailBoundary(id) {
    return request({
      url: `/yunshou/aiAlgorithmCase/${id}`,
      method: 'get',
    })
  }
  

// 新增算法边界列表
export function addBoundary(data) {
  return request({
    url: '/yunshou/aiAlgorithmCase',
    method: 'post',
    data: data
  })
}

// 修改算法边界列表
export function updateBoundary(data) {
    return request({
      url: '/yunshou/aiAlgorithmCase',
      method: 'put',
      data: data
    })
  }
  

// 删除算法边界列表
export function deleteBoundary(ids) {
  return request({
    url: `/yunshou/aiAlgorithmCase/${ids}`,
    method: 'delete'
  })
}
