/** 
 * 新增告警等级配置
 * @param {object} params 告警等级配置
 * @param {string} params.alarmColor 告警颜色
 * @param {string} params.alarmName 告警名称
 * @param {string} params.alarmShowType 告警展示方式
 * @param {number} params.id 主键
 * @returns
 */
import request from '@/utils/request'

// 查询算法列表
export function listAlgLevel(query) {
    return request({
      url: '/yunshou/alarmLevel/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法列表x详情
export function detailAlgLevel(id) {
    return request({
      url: `/yunshou/alarmLevel/${id}`,
      method: 'get',
    })
  }
  

// 新增算法列表
export function addAlgLevel(data) {
  return request({
    url: '/yunshou/alarmLevel',
    method: 'post',
    data: data
  })
}

// 修改算法列表
export function updateAlgLevel(data) {
    return request({
      url: '/yunshou/alarmLevel',
      method: 'put',
      data: data
    })
  }
  

// 删除算法列表
export function deleteAlgLevel(ids) {
  return request({
    url: `/yunshou/alarmLevel/${ids}`,
    method: 'delete'
  })
}
