import { onMounted, ref, watch } from "vue";
import request from "@/utils/request";
import { ElMessageBox } from "element-plus";
function useIndex(apis, callback, listReady, immList = true) {
  const visible = ref(false);
  const search = ref({});
  const form = ref({
    regionName: "",
  });
  const list = ref([]);
  const page = ref({
    pageNum: 1,
    pageSize: 10,
    total: 0,
  });

  watch(
    () => visible.value,
    (newVal) => {
      if (newVal == false) {
        form.value = {};
      }
    }
  );

  watch([() => page.value.pageNum, () => page.value.pageSize], (val) => {
    getList();
  });
  function toEdit(data) {
    getDetail(data.id);
    visible.value = true;
  }
  function toAdd() {
    visible.value = true;
  }
  function toDel(data, immclose = true) {
    //弹框确认
    return new Promise((resolve) => {
      ElMessageBox.confirm("是否删除？").then(() => {
        request({
          url: apis.delete + data.id,
          method: "delete",
        }).then((res) => {
          if (immclose) {
            visible.value = false;
            getList();
          }
          resolve();
        });
      });
    });
  }
  function getList(params, isFirst) {
    return request({
      url: apis.list,
      method: "get",
      params: { ...params, ...page.value, ...search.value },
    }).then((res) => {
      list.value = res.data || res.rows;
      page.value.total = res.total;
      if (isFirst) {
        listReady && listReady(res.data);
      }
    });
  }
  function getDetail(id) {
    return request({
      url: apis.detail + id,
      method: "get",
    }).then((res) => {
      callback && callback(res);
      form.value = res.data;
      return res;
    });
  }

  function editSubmit(data) {
    request({
      url: apis.edit,
      method: "put",
      data,
    }).then((res) => {
      if (immclose) {
        visible.value = false;
        getList();
      }
      resolve();
    });
  }
  function toSubmit(immclose = true) {
    return new Promise((resolve, reject) => {
      if (form.value.id) {
        request({
          url: apis.edit,
          method: "put",
          data: form.value,
        }).then((res) => {
          if (immclose) {
            visible.value = false;
            getList();
          }
          resolve();
        });
      } else {
        request({
          url: apis.add,
          method: "post",
          data: form.value,
        }).then((res) => {
          if (immclose) {
            visible.value = false;
            getList();
          }
          resolve();
        });
      }
    });
  }

  function toClose() {
    visible.value = false;
  }
  function toOpen() {
    visible.value = false;
  }
  onMounted(() => {
    if (apis.list && immList) {
      getList({}, true);
    }
  });

  return {
    visible,
    form,
    list,
    page,
    toEdit,
    toAdd,
    toDel,
    getDetail,
    toClose,
    toSubmit,
    getList,
    toOpen,
    search,
    editSubmit,
  };
}

export { useIndex };
