/** 
 * 新增算法文件
 * @param {object} params 算法文件
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {object} params.params 
 * @param {string} params.remark 
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @param {string} params.id 主键
 * @param {string} params.algorithmId 算法id
 * @param {string} params.algorithmName 算法名称
 * @param {string} params.algorithmStatus 算法状态 0上传中 1已发布
 * @param {string} params.md5Result MD5核对结果
 * @param {string} params.algorithmFile 算法文件
 * @param {string} params.fileSize 文件大小
 * @returns
 */
import request from '@/utils/request'

// 查询算法文件
export function listFile(query) {
    return request({
      url: '/yunshou/aiAlgorithmFile/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法文件x详情
export function detailFile(id) {
    return request({
      url: `/yunshou/aiAlgorithmFile/${id}`,
      method: 'get',
    })
  }
  

// 新增算法文件
export function addFile(data) {
  return request({
    url: '/yunshou/aiAlgorithmFile',
    method: 'post',
    data: data
  })
}

// 使用当前版本算法文件
export function useCurrentFil(algorithmFileId) {
  return request({
    url: `/yunshou/aiAlgorithmFile/useCurrentFile/${algorithmFileId}`,
    method: 'post',
  })
}

// 修改算法文件
export function updateFile(data) {
    return request({
      url: '/yunshou/aiAlgorithmFile',
      method: 'put',
      data: data
    })
  }
  

// 删除算法文件
export function deleteFile(ids) {
  return request({
    url: `/yunshou/aiAlgorithmFile/${ids}`,
    method: 'delete'
  })
}
