// 随机生成十个颜色
export const colors = () => {
  const r = Math.floor(Math.random() * 256);
  const g = Math.floor(Math.random() * 256);
  const b = Math.floor(Math.random() * 256);
  const a = 0.8;
  return `rgba(${r},${g},${b},${a})`;
};

export function drawImage(video) {
  const img = video;
  const canvas = document.getElementById("canvas");
  const ctx = canvas.getContext("2d");
  canvas.width = img.offsetWidth;
  canvas.height = img.offsetHeight;
  ctx.drawImage(img, 0, 0, canvas.width, canvas.height); // 绘制图片
  return canvas.toDataURL("image/jpg");
}

export function base64ToFile(base64) {
  const name = new Date().getTime();
  if (typeof base64 != "string") {
    return;
  }
  var arr = base64.split(",");
  var type = arr[0].match(/:(.*?);/)[1];
  var fileExt = type.split("/")[1];
  var bstr = atob(arr[1]);
  var n = bstr.length;
  var u8arr = new Uint8Array(n);
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n);
  }
  return new File([u8arr], `${name}.` + fileExt, {
    type: type,
  });
}
